/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateLineStartToMiddle.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "cApplication.h"
#include "cLine.h"

//	Creates a line using the start point of the given line1 and the
//	mid point of the given line2 and returns the line created
//	After creation the line is AutoConstrained.

HRESULT CreateLineStartToMiddle(ILine *line1, ILine *line2, ILine **newLine1)
{

	START_METHOD("CreateLineStartToMiddle")

	HRESULT status = CONV_SUCCESS;

	// Get the start point of the first line
	IPoint *startPoint1 = NULL;
	status = line1->GetStartPoint(&startPoint1);
	CHECK_RETURN_STATUS(status)

	// Get the mid point of the second line
	IPoint *midPoint1 = NULL;
	status = GetMidPoint(line2, &midPoint1);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL;
	status = CreateLinePointToPoint(startPoint1, midPoint1, &pLine1);
	CHECK_RETURN_STATUS(status)

	*newLine1 = pLine1;

	END_METHOD("CreateLineStartToMiddle")
}
